#ifndef RINGBUFFER_H
#define RINGBUFFER_H

#include "CommonUtil.h"
#include <cstring>

#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable
using namespace std;
class ringBuffer{

private:
	unsigned char *bufferHead;
	unsigned int totalBufferSize;
	unsigned int readIndex;
	unsigned int writeIndex;
	int virtualTotalBufSize;
	int availableSize;
	std::mutex ringBufMutex;
	std::condition_variable ringBufConVar;
	u32 getFillLevel();
	bool getAvailableBufSize(const int inDataLen);

	bool running;

public:
	ringBuffer();
  ~ ringBuffer();

  void terminate();
  bool allocateBuffer(int size);

  bool readFromRingBuffer(u8* outData, u32 inLen);
  bool writeToRingBuffer(u8*, const u32);


};
#endif //RINGBUFFER_H
